'use strict';

/* --------------------------------------------------------------
 scroll_to_top.js 2016-04-25
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Scroll to top functionality.
 */
gx.controllers.module('scroll_to_top', [], function () {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    /**
     * Animation Flag
     *
     * @type {Boolean}
     */
    var onAnimation = false;

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * On Window Scroll
     *
     * If the site content is large and the user has scrolled to bottom display the caret icon.
     */
    function _onWindowScroll() {
        var scrollPercentage = ($(window).scrollTop() + window.innerHeight) / $(document).outerHeight();

        if (!onAnimation && !$('#main-menu > nav > ul').hasClass('collapse') && scrollPercentage > 0.9 && $(document).outerHeight() > 2500) {
            $this.fadeIn();
        } else if ($this.is(':visible')) {
            $this.fadeOut();
        }
    }

    /**
     * On Icon Click
     *
     * Scroll to the top of the page whenever the user clicks on the caret icon.
     */
    function _onIconClick() {
        onAnimation = true;

        $('html, body').animate({
            scrollTop: 0
        }, 'fast', function () {
            onAnimation = false;
        });

        $this.fadeOut();
    }

    // ------------------------------------------------------------------------
    // INITIALIZE
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $(window).on('scroll', _onWindowScroll);
        $this.on('click', 'i', _onIconClick);
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
